import React from "react";
import { Permissions } from "../constants";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
    faPieChart,
    faUser,
    faTruck,
    faUserGroup,
    faHome,
    faBoxes,
    faPrint,
    faBookmark,
    faBoxOpen,
    faMoneyCheckDollar,
    faMoneyBills,
    faQuoteRight,
    faDollarSign,
    faReceipt,
    faArrowRight,
    faArrowLeft,
    faEnvelope,
    faCartShopping,
    faChartColumn,
    faGear,
    faMapLocation,
    faBasketShopping,
    faSms,
    faCube,
    faFile,
    faRulerHorizontal,
    faLanguage,
    faShieldHalved,
    faLayerGroup,
    faMoneyBill,
    faTableColumns,
    faMoneyBill1Wave,
    faCircleQuestion,
    faStore,
    faMoneyCheck,
    faDisplay,
} from "@fortawesome/free-solid-svg-icons";
import { getFormattedMessage } from "../shared/sharedMethod";

export const userMenu = [
    {
        title: "dashboard.title",
        name: "dashboard",
        fontIcon: <FontAwesomeIcon icon={faPieChart} />,
        to: "/app/user/dashboard",
        class: "d-flex",
        permission: Permissions.MANAGE_DASHBOARD,
        items: [
            {
                title: getFormattedMessage("dashboard.title"),
                to: "/app/user/dashboard",
            },
        ],
    },
    {
        title: "products.title",
        name: "products",
        fontIcon: <FontAwesomeIcon icon={faBoxes} />,
        to: "/app/user/products",
        class: "d-flex",
        is_submenu: "true",
        permission: Permissions.MANAGE_PRODUCTS,
        subPath: {
            productsSubPath: "/app/user/products",
            categoriesSubPath: "/app/user/product-categories",
            variationsSubPath: "/app/user/variations",
            brandsSubPath: "/app/user/brands",
            unitsSubPath: "/app/user/units",
            baseUnitsSubPath: "/app/user/base-units",
            barcodeSubPath: "/app/user/print/barcode",
        },
        subMenu: [
            {
                title: "products.title",
                to: "/app/user/products",
                name: "products",
                class: "d-flex",
                fontIcon: <FontAwesomeIcon icon={faBoxes} />,
                permission: Permissions.MANAGE_PRODUCTS,
            },
            {
                title: "product.categories.title",
                name: "product categories",
                fontIcon: <FontAwesomeIcon icon={faBoxOpen} />,
                to: "/app/user/product-categories",
                class: "d-flex",
                permission: Permissions.MANAGE_PRODUCT_CATEGORIES,
            },
            {
                title: "variations.title",
                name: "variations",
                fontIcon: <FontAwesomeIcon icon={faLayerGroup} />,
                to: "/app/user/variations",
                class: "d-flex",
                permission: Permissions.MANAGE_VARIATIONS,
            },

            {
                title: "brands.title",
                name: "brands",
                fontIcon: <FontAwesomeIcon icon={faBookmark} />,
                to: "/app/user/brands",
                path: "/app/user/create-brand",
                class: "d-flex",
                permission: Permissions.MANAGE_BRANDS,
            },
            {
                title: "units.title",
                name: "units",
                fontIcon: <FontAwesomeIcon icon={faQuoteRight} />,
                to: "/app/user/units",
                class: "d-flex",
                permission: Permissions.MANAGE_UNITS,
            },
            {
                title: "base-units.title",
                name: "base units",
                fontIcon: <FontAwesomeIcon icon={faRulerHorizontal} />,
                to: "/app/user/base-units",
                class: "d-flex",
                permission: Permissions.MANAGE_UNITS,
            },
            {
                title: "print.barcode.title",
                name: "print barcode",
                fontIcon: <FontAwesomeIcon icon={faPrint} />,
                to: "/app/user/print/barcode",
                class: "d-flex",
                permission: Permissions.MANAGE_PRODUCTS,
            },
        ],
    },
    {
        title: "adjustments.title",
        name: "adjustments",
        fontIcon: <FontAwesomeIcon icon={faMapLocation} />,
        to: "/app/user/adjustments",
        class: "d-flex",
        permission: Permissions.MANAGE_ADJUSTMENTS,
        items: [
            {
                title: getFormattedMessage("adjustments.title"),
                to: "/app/user/adjustments",
            },
        ],
    },
    {
        title: "quotations.title",
        name: "quotations.title",
        fontIcon: <FontAwesomeIcon icon={faBasketShopping} />,
        to: "/app/user/quotations",
        class: "d-flex",
        permission: Permissions.MANAGE_QUOTATION,
        items: [
            {
                title: getFormattedMessage("quotations.title"),
                to: "/app/user/quotations",
            },
        ],
    },
    {
        title: "purchases.title",
        name: "purchases",
        fontIcon: <FontAwesomeIcon icon={faReceipt} />,
        to: "/app/user/purchases",
        class: "d-flex",
        is_submenu: "true",
        permission: Permissions.MANAGE_PURCHASE,
        subPath: {
            purchasesSubPath: "/app/user/purchases",
            purchaseReturnSubPath: "/app/user/purchase-return",
        },
        subMenu: [
            {
                title: "purchases.title",
                name: "purchases",
                fontIcon: <FontAwesomeIcon icon={faReceipt} />,
                to: "/app/user/purchases",
                class: "d-flex",
                permission: Permissions.MANAGE_PURCHASE,
            },
            {
                title: "purchases.return.title",
                name: "purchases return",
                fontIcon: <FontAwesomeIcon icon={faArrowLeft} />,
                to: "/app/user/purchase-return",
                class: "d-flex",
                permission: Permissions.MANAGE_PURCHASE_RETURN,
            },
        ],
    },
    {
        title: "sales.title",
        name: "sales",
        fontIcon: <FontAwesomeIcon icon={faCartShopping} />,
        to: "/app/user/sales",
        class: "d-flex",
        is_submenu: "true",
        permission: Permissions.MANAGE_SALE,
        subPath: {
            salesSubPath: "/app/user/sales",
            salesReturnSubPath: "/app/user/sale-return",
        },
        subMenu: [
            {
                title: "sales.title",
                name: "sales",
                fontIcon: <FontAwesomeIcon icon={faCartShopping} />,
                to: "/app/user/sales",
                class: "d-flex",
                permission: Permissions.MANAGE_SALE,
            },
            {
                title: "sales-return.title",
                name: "sales return",
                fontIcon: <FontAwesomeIcon icon={faArrowRight} />,
                to: "/app/user/sale-return",
                class: "d-flex",
                permission: Permissions.MANAGE_SALE_RETURN,
            },
        ],
    },
    {
        title: "transfers.title",
        name: "transfers",
        fontIcon: <FontAwesomeIcon icon={faMapLocation} />,
        to: "/app/user/transfers",
        class: "d-flex",
        permission: Permissions.MANAGE_TRANSFERS,
        items: [
            {
                title: getFormattedMessage("transfers.title"),
                to: "/app/user/transfers",
            },
        ],
    },
    {
        title: "expenses.title",
        name: "expenses",
        fontIcon: <FontAwesomeIcon icon={faMoneyBills} />,
        to: "/app/user/expenses",
        class: "d-flex",
        is_submenu: "true",
        permission: Permissions.MANAGE_EXPENSES,
        subPath: {
            expensesSubPath: "/app/user/expenses",
            expenseCategoriesSubPath: "/app/user/expense-categories",
        },
        subMenu: [
            {
                title: "expenses.title",
                name: "expenses",
                fontIcon: <FontAwesomeIcon icon={faMoneyBills} />,
                to: "/app/user/expenses",
                class: "d-flex",
                permission: Permissions.MANAGE_EXPENSES,
            },
            {
                title: "expense.categories.title",
                name: "expense categories",
                fontIcon: <FontAwesomeIcon icon={faMoneyCheckDollar} />,
                class: "d-flex",
                permission: Permissions.MANAGE_EXPENSES_CATEGORIES,
                to: "/app/user/expense-categories",
            },
        ],
    },
    {
        title: "pepole.title",
        name: "Pepoles",
        fontIcon: <FontAwesomeIcon icon={faUser} />,
        to: "/app/user/suppliers",
        class: "d-flex",
        is_submenu: "true",
        subPath: {
            customerSubPath: "/app/user/customers",
            userSubPath: "/app/user/users",
            suppliareSubPath: "/app/user/suppliers",
        },
        permission:
            Permissions.MANAGE_SUPPLIERS ||
            Permissions.MANAGE_CUSTOMERS ||
            Permissions.MANAGE_USER,
        subMenu: [
            {
                title: "suppliers.title",
                name: "suppliers",
                fontIcon: <FontAwesomeIcon icon={faTruck} />,
                to: "/app/user/suppliers",
                class: "d-flex",
                permission: Permissions.MANAGE_SUPPLIERS,
            },
            {
                title: "customers.title",
                name: "customers",
                fontIcon: <FontAwesomeIcon icon={faUserGroup} />,
                to: "/app/user/customers",
                class: "d-flex",
                permission: Permissions.MANAGE_CUSTOMERS,
            },
            {
                title: "users.title",
                name: "users",
                fontIcon: <FontAwesomeIcon icon={faUser} />,
                to: "/app/user/users",
                class: "d-flex",
                permission: Permissions.MANAGE_USER,
            },
        ],
    },
    {
        title: "roles.permissions.title",
        name: "roles",
        fontIcon: <FontAwesomeIcon icon={faShieldHalved} />,
        to: "/app/user/roles",
        class: "d-flex",
        permission: Permissions.MANAGE_ROLES,
        items: [
            {
                title: getFormattedMessage("roles.title"),
                to: "/app/user/roles",
            },
        ],
    },
    {
        title: "warehouse.title",
        name: "warehouse",
        fontIcon: <FontAwesomeIcon icon={faHome} />,
        to: "/app/user/warehouses",
        class: "d-flex",
        permission: Permissions.MANAGE_WAREHOUSES,
        items: [
            {
                title: getFormattedMessage("warehouse.title"),
                to: "/app/user/warehouse",
            },
        ],
    },
    {
        title: "reports.title",
        name: "reports",
        fontIcon: <FontAwesomeIcon icon={faChartColumn} />,
        to: "/app/user/report/report-warehouse",
        path: "/app/user/report/report-sale",
        stockPath: "/app/user/report/report-stock",
        purchasePath: "/app/user/report/report-purchase",
        topSellingPath: "/app/user/report/report-top-selling-products",
        stockDetailPath: "/app/user/report/report-detail-stock",
        productQuantityAlertPath: "/app/user/report/report-product-quantity",
        supplierReportPath: "/app/user/report/suppliers",
        profitLossReportPath: "/app/user/report/profit-loss",
        supplierReportDetailsPath: "/app/user/report/suppliers/details",
        bestCustomerReportPath: "/app/user/report/best-customers",
        customerReportPath: "/app/user/report/customers",
        customerReportDetailsPath: "/app/user/report/customers/details",
        registerReportPath: "/app/user/report/register",
        class: "d-flex",
        isSamePrefix: "true",
        permission: Permissions.MANAGE_REPORTS,
        subTitles: [
            { title: "warehouse.reports.title" },
            { title: "sale.reports.title" },
            { title: "stock.reports.title" },
            { title: "purchase.reports.title" },
            { title: "top-selling-product.reports.title" },
            { title: "product.quantity.alert.reports.title" },
            { title: "supplier.report.title" },
            { title: "best-customer.report.title" },
            { title: "customer.report.title" },
            { title: "customer.report.title" },
            { title: "profit-loss.reports.title" },
            { title: "best-customer.report.title" },
            { title: "register.report.title" },
        ],
        items: [
            {
                title: getFormattedMessage("warehouse.reports.title"),
                to: "/app/user/report/report-warehouse",
            },
            {
                title: getFormattedMessage("sale.reports.title"),
                to: "/app/user/report/report-sale",
            },
            {
                title: getFormattedMessage("stock.reports.title"),
                to: "/app/user/report/report-stock",
                detail: "/app/user/report/report-detail-stock",
            },
            {
                title: getFormattedMessage("purchase.reports.title"),
                to: "/app/user/report/report-purchase",
            },
            {
                title: getFormattedMessage("top-selling-product.reports.title"),
                to: "/app/user/report/report-top-selling-products",
            },
            {
                title: getFormattedMessage(
                    "product.quantity.alert.reports.title"
                ),
                to: "/app/user/report/report-product-quantity",
            },
            {
                title: getFormattedMessage("supplier.report.title"),
                to: "/app/user/report/suppliers",
                detail: "/app/user/report/suppliers/details",
            },
            {
                title: getFormattedMessage("profit-loss.reports.title"),
                to: "/app/user/report/profit-loss",
            },
            {
                title: getFormattedMessage("best-customer.report.title"),
                to: "/app/user/report/best-customers",
            },
            {
                title: getFormattedMessage("customer.report.title"),
                to: "/app/user/report/customers",
                detail: "/app/user/report/customers/details",
            },
            {
                title: getFormattedMessage("register.report.title"),
                to: "/app/user/report/register",
            },
        ],
    },
    {
        title: "template.title",
        name: "template",
        fontIcon: <FontAwesomeIcon icon={faFile} />,
        to: "/app/user/email-templates",
        class: "d-flex",
        is_submenu: "true",
        permission: Permissions.MANAGE_EMAIL_TEMPLATES,
        subPath: {
            emailTemplateSubPath: "/app/user/email-templates",
            smsTemplateSubPath: "/app/user/sms-templates",
            smsApiSubPath: "/app/user/sms-api",
        },
        subMenu: [
            {
                title: "email-template.title",
                name: "email-templates",
                fontIcon: <FontAwesomeIcon icon={faEnvelope} />,
                to: "/app/user/email-templates",
                class: "d-flex",
                permission: Permissions.MANAGE_EMAIL_TEMPLATES,
            },
            {
                title: "sms-template.title",
                name: "sms-templates",
                fontIcon: <FontAwesomeIcon icon={faSms} />,
                to: "/app/user/sms-templates",
                class: "d-flex",
                permission: Permissions.MANAGE_SMS_TEMPLATES,
            },
            {
                title: "sms-api.title",
                name: "sms-api",
                fontIcon: <FontAwesomeIcon icon={faCube} />,
                to: "/app/user/sms-api",
                class: "d-flex",
                permission: Permissions.MANAGE_SMS_API,
            },
        ],
    },
    {
        to: "/app/user/pos",
        class: "d-none",
        name: "pos",
        title: "header.pos.title",
        permission: Permissions.MANAGE_POS_SCREEN,
    },
    {
        title: "settings.title",
        name: "settings",
        fontIcon: <FontAwesomeIcon icon={faGear} />,
        to: "/app/user/settings",
        prefixesPath: "/app/user/prefixes",
        receiptSettingsPath: "/app/user/receipt-settings",
        taxesPath: "/app/user/taxes",
        posSettingsPath: "/app/user/pos-settings",
        class: "d-flex",
        isSamePrefix: "true",
        permission: Permissions.MANAGE_SETTING,
        subTitles: [
            { title: "prefix.title" },
            { title: "receipt-settings.title" },
            { title: "taxes.title" },
            { title: "pos.settings.title" },
        ],
        items: [
            {
                title: getFormattedMessage("settings.title"),
                to: "/app/user/settings",
            },
            {
                title: getFormattedMessage("prefix.title"),
                to: "/app/user/prefixes",
            },
            {
                title: getFormattedMessage("receipt-settings.title"),
                to: "/app/user/receipt-settings",
            },
            {
                title: getFormattedMessage("taxes.title"),
                to: "/app/user/taxes",
            },
            {
                title: getFormattedMessage("pos.settings.title"),
                to: "/app/user/pos-settings",
            },
        ],
    },
    {
        title: "store.title",
        name: "store",
        fontIcon: <FontAwesomeIcon icon={faStore} />,
        to: "/app/user/store",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("store.title"),
                to: "/app/user/store",
            },
        ],
    },
    {
        title: "payment.methods.title",
        name: "payment-methods",
        fontIcon: <FontAwesomeIcon icon={faMoneyCheck} />,
        to: "/app/user/payment-methods",
        class: "d-flex",
        permission: '',
        items: [
            {
                title: getFormattedMessage("payment.methods.title"),
                to: "/app/user/payment-methods",
            },
        ],
    },
    {
        title: "dual.screen.settings.title",
        name: "store",
        fontIcon: <FontAwesomeIcon icon={faDisplay} />,
        to: "/app/user/dual-screen-settings",
        class: "d-flex",
        permission: Permissions.MANAGE_POS_SCREEN,
        items: [
            {
                title: getFormattedMessage("dual.screen.settings.title"),
                to: "/app/user/dual-screen-settings",
            },
        ],
    },

];

export const adminMenu = [
    {
        title: "dashboard.title",
        name: "dashboard",
        fontIcon: <FontAwesomeIcon icon={faPieChart} />,
        to: "/app/admin/dashboard",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("dashboard.title"),
                to: "/app/admin/dashboard",
            },
        ],
    },
    {
        title: "users.title",
        name: "users",
        fontIcon: <FontAwesomeIcon icon={faUser} />,
        to: "/app/admin/users",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("users.title"),
                to: "/app/admin/users",
            },
        ],
    },
    {
        title: "plans.title",
        name: "plans",
        fontIcon: <FontAwesomeIcon icon={faTableColumns} />,
        to: "/app/admin/plans",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("plans.title"),
                to: "/app/admin/plans",
            },
        ],
    },
    {
        title: "cash-payments.title",
        name: "Cash Payments",
        fontIcon: <FontAwesomeIcon icon={faMoneyBill} />,
        to: "/app/admin/cash-payments",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("cash-payments.title"),
                to: "/app/admin/cash-payments",
            },
        ],
    },
    {
        title: "subscriptions.title",
        name: "Subscriptions",
        fontIcon: <FontAwesomeIcon icon={faMoneyBills} />,
        to: "/app/admin/subscriptions",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("subscriptions.title"),
                to: "/app/admin/subscriptions",
            },
        ],
    },
    {
        title: "transactions.title",
        name: "Subscriptions",
        fontIcon: <FontAwesomeIcon icon={faMoneyBill1Wave} />,
        to: "/app/admin/transactions",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("transactions.title"),
                to: "/app/admin/transactions",
            },
        ],
    },
    {
        title: "currencies.title",
        name: "currencies",
        fontIcon: <FontAwesomeIcon icon={faDollarSign} />,
        to: "/app/admin/currencies",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("currencies.title"),
                to: "/app/admin/currencies",
            },
        ],
    },
    {
        title: "languages.title",
        name: "Languages",
        fontIcon: <FontAwesomeIcon icon={faLanguage} />,
        to: "/app/admin/languages",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("languages.title"),
                to: "/app/admin/languages",
            },
        ],
    },
    {
        title: "inquiries.title",
        name: "Inquiries",
        fontIcon: <FontAwesomeIcon icon={faCircleQuestion} />,
        to: "/app/admin/inquiries",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("inquiries.title"),
                to: "/app/admin/inquiries",
            },
        ],
    },
    {
        title: "front-cms.title",
        name: "Front CMS",
        fontIcon: <FontAwesomeIcon icon={faHome} />,
        to: "/app/admin/front-cms/hero-section",
        path: "/app/admin/front-cms/services",
        partnersPath: "/app/admin/front-cms/partners",
        whyChoosUsPath: "/app/admin/front-cms/why-choose-us",
        testimonialsPath: "/app/admin/front-cms/testimonials",
        faqsPath: "/app/admin/front-cms/faqs",
        pagesPath: "/app/admin/front-cms/pages",
        termsPath: "/app/admin/front-cms/pages/terms-conditions",
        privacyPath: "/app/admin/front-cms/pages/privacy-policy",
        refundPath: "/app/admin/front-cms/pages/refund-policy",
        featurePath: "/app/admin/front-cms/features",
        stepPath: "/app/admin/front-cms/steps",
        class: "d-flex",
        isSamePrefix: "true",
        permission: "",
        subTitles: [
            { title: "front-cms.hero-section.title" },
            { title: "front-cms.services.title" },
            { title: "front-cms.partners.title" },
            { title: "front-cms.why.choose.us.title" },
            { title: "front-cms.testimonials.title" },
            { title: "front-cms.faqs.title" },
            { title: "features.title" },
            { title: "front.cms.step.title" },
            { title: "front-cms.pages.title" }
        ],
        items: [
            {
                title: getFormattedMessage("front-cms.hero-section.title"),
                to: "/app/admin/front-cms/hero-section",
            },
            {
                title: getFormattedMessage("front-cms.services.title"),
                to: "/app/admin/front-cms/services",
            },
            {
                title: getFormattedMessage("front-cms.partners.title"),
                to: "/app/admin/front-cms/partners",
            },
            {
                title: getFormattedMessage("front-cms.why.choose.us.title"),
                to: "/app/admin/front-cms/why-choose-us",
            },
            {
                title: getFormattedMessage("front-cms.faqs.title"),
                to: "/app/admin/front-cms/faqs",
            },
            {
                title: getFormattedMessage("front-cms.testimonials.title"),
                to: "/app/admin/front-cms/testimonials",
            },
            {
                title: getFormattedMessage("features.title"),
                to: "/app/admin/front-cms/features",
            },
            {
                title: getFormattedMessage("front.cms.step.title"),
                to: "/app/admin/front-cms/steps",
            },
            {
                title: getFormattedMessage("front-cms.pages.title"),
                to: "/app/admin/front-cms/pages/terms-conditions",
                privacyDetail: "/app/admin/front-cms/pages/privacy-policy",
                refundDetail: "/app/admin/front-cms/pages/refund-policy",
            },
        ],
    },
    {
        title: "settings.title",
        name: "settings",
        fontIcon: <FontAwesomeIcon icon={faGear} />,
        to: "/app/admin/settings",
        mailSettingsPath: "/app/admin/mail-settings",
        paymentSettingsPath: "/app/admin/payment-settings",
        class: "d-flex",
        isSamePrefix: "true",
        permission: "",
        isSingleActive: true,
        subTitles: [
            { title: "payment-settings.title" },
            { title: "mail-settings.title" },
        ],
        items: [
            {
                title: getFormattedMessage("settings.title"),
                to: "/app/admin/settings",
            },
        ],
    }
];
